#ifndef _GAME_
#define _GAME_
typedef struct Game Game;
#include "common.h"
#include "block.h"
#include "isometric.h"
#include "render.h"
#include "blocks/skunk.h"
#include "blocks/elephant.h"
#include "save.h"
#include "input.h"
#include "menu.h"
#include "overview.h"
#include "editor.h"
#include "data.h"
#include "dialog.h"
struct Game {
    int level;
    Blocks * blocks;
    float waypoints [10] [3];
    int waypoints_count;
    Viewport * viewport;
    char const * state;
    int ticks;
    int state_tick;
    Block * skunk;
    Block * elephant;
    Block * orchid;
    Block * gnome;
    Block * lever;
    double start_time;
    char hint [1024];
    char title [1024];
    bool pristine;
    int gox, goz;
    int ex, ez;
    int enter_x, enter_y, enter_z;
    int enter_x2, enter_y2, enter_z2;
    float target_x, target_z;
    bool want_friend;
    int swap_level;
    bool flower [8];
    bool test_tube [8];
    bool key;
    int deaths;
    int deaths_per_minute [30];
    int levels_in_minute [30];
    int first_minute;
    int seen;
    Menu * menu;
    bool menu_on;
    Overview * overview;
    Dialog dialog;
};
extern Game * game;
extern int game_starting_level;
Game* game_global(void);
int blocks_count(void);
void game_setup(float w, float h);
void game_del(Game * self);
int game_neighboring_level(int level, int gox, int goz);
void game_level_number_to_xz(int level, int * x, int * z);
void game_level_done(Game * self, int gox, int goz);
void game_recalc(void);
void game_key(Game * self, int k);
void add_death(void);
void game_tick(Game * self);
#endif
